# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 1
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR1_strategy.txt
# LLM Suggested Fallback: C

def friendly_neighbor(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    if len(my_history) >= 8 and sum(1 for move in opp_history if move == "D") > 1:
        return "D"
    
    if "always defect" in opponent_program_code.lower():
        return "D"
    
    if "always cooperate" in opponent_program_code.lower():
        return "D" if len(my_history) > 5 else "C"
    
    if opp_history[-1] == "D" and random.random() < 0.1:
        return "C"
    
    return opp_history[-1]